
@extends('layouts.print')

@section('content')
<?php
    $branch = DB::table('nso007_branch')->find(1);
    $total_price  = 0;
    $total        = 0;
    $delivery_note = '';
?>
<div class="content-wrapper">
    <div class="box">
        <div class="content">
            <div class="container">
                <div class="page">
                    <div class="navbar-top">
                        <div class="margin-tb">
                            <div class="sticker">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <table style="width:46%" border="0">
                                            <tr>
                                                <td>
                                                    <center>
                                                        <img src="{{asset('images/logo1.png')}}" alt="" width="90">
                                                    </center>
                                                </td>
                                            </tr>
                                        </table>

                                        <table style="width:46%; margin-top: -20px;" border="0">
                                            <tr>
                                                <td>
                                                    <div class="sticker-title">
                                                        <h4 class="mycompany">{{ $branch->company_name }}</h4>
                                                        <p class="text-center">{{ $branch->address }}<br>
                                                            {{ $branch->phone }}</p>
                                                    <div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h3 class="title-invoice">
                                                        <b>
                                                            វិក័យប័ត្រផ្ញើឥវ៉ាន់
                                                            </b>
                                                    </h3>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="delivery-invoice">

                                            <p>ទីតាំង​ : {{ $data[0]->location_name }}</p>
                                            <p>លេខអ្នកទទួល​ : {{ $data[0]->customer_receive }}</p>
                                            <p>ឈ្មោះហាង : {{ $data[0]->shop_name }}</p>
                                            <p>លេខហាង : {{ $data[0]->phone }}</p>
                                            <p>លេខតាក់ស៊ី  : {{ $data[0]->taxi_number }}</p>
                                        </div>
                                    <div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <table style="width:46%">
                                            <tr style="background: #eee !important;padding: 5px 10px 20px 10px">
                                                <td width="20%">ល.រ</td>
                                                <td width="60%">បរិយាយ</td>
                                                <td width="20%">ចំនួន</td>
                                                <td width="60%">តម្លៃ</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <table style="width:46%; border-bottom: 1px solid #dddddd;margin-bottom: 20px;">
                                            @foreach($data as $key => $value)

                                                <?php
                                                    $total_price += ($value->price * $value->export_qty )  ;
                                                ?>
                                                <tr>
                                                    <td width="20%">{{$key+1}}</td>
                                                    <td width="60%">{{$value->items}}   </td>
                                                    <td width="20%">{{$value->export_qty}}   </td>
                                                    <td width="20%" class="text-left">{{ '$'.number_format( $value->price * $value->export_qty,2) }}</td>
                                                </tr>
                                            @endforeach()
                                        </table>
                                    </div>
                                </div>

                                <?php
                                    if($data[0]->delivery_status == 1 ){
                                        $total  =  $total_price  ;
                                        $delivery_note  = 'យកសេវាដឹកជញ្ជូនយកខាងហាង';
                                    }
                                    else{
                                        $total  =  $total_price + $value->delivery_fee;
                                        $delivery_note  = 'សេវាដឹកជញ្ជូនខាងអ្នកទទួល' ;
                                    }​
                                ?>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="sub-total">
                                            <p>តម្លៃទំនិញ : <span style="margin-left: 33px">{{ '$'.number_format( $total_price,2) }}</span></p>
                                            <p>តម្លៃសេវា &nbsp&nbsp: ​<span style="margin-left: 29px">{{ '$'.number_format( $data[0]->delivery_fee,2) }}</span></p>
                                            <p><b>តម្លៃសរុប &nbsp&nbsp: <span style="margin-left: 24px">{{ '$'.number_format( $total,2) }}</span></b></p>

                                            <p>កាលបរិច្ឆេទ: ​<span style="margin-left: 19px">{{ date('d-m-Y') }}</span></p>

                                        </div>
                                        <p class="bar-code"><svg id="barcode"></svg></p>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <b style="font-size:20px;float:left"><u>ចំណាំ:</u></b>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="delivery-invoice">
                                        <p  class="text-left note" >​ -  {{  $delivery_note  }}  </p>
                                        <p  class="text-left note" >​ -  រាល់ឥវ៉ាន់ខុសច្បាប់ម្ចាស់ឥវ៉ាន់ជាអ្នកទទួលខុសត្រូវ។  </p>
                                        <p  class="text-left note" >​ -  អគុណសម្រាប់ការប្រើប្រាស់សេវាកម្មយើងខ្ញុំ។  </p>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{!! Form::close() !!}
@endsection

@section('script')

<script type="text/javascript">
    JsBarcode("#barcode", "{{$data[0]->box_code}}");
</script>

<style>
    .note{
        font-size: 15px !important;
    }
.sticker table tr td{font-weight:200;border: 0 !important;}
.sticker thead{background: #eee !important;}
.sticker table td{padding:0px;font-size: 20px !important}

.sticker .delivery-invoice{
    margin-bottom: 20px;
}
.sticker .delivery-invoice p{
    font-size: 20px;
    margin: 0px;
}
.title-invoice{
    text-align: center;
    margin: -10px 0px 8px 0px;
    border-top: 1px solid;
    padding: 8px 0px;
    border-bottom: 1px dashed #000;
    font-size: 20px;
}
.mycompany{
    text-align: center;
    font-weight: 700;
    font-size: 20px;
}
.sub-total{
    margin-left: 100px;
}
.sub-total p{
    font-size: 20px;
    margin: 0px;
}
.bar-code{
    margin-left: 40px;
}

</style>
@endsection











